<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Granbell Hotel UI</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@200;300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- AOS CSS -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="<?php echo e(url('style.css')); ?>">
</head>

<body>

    <div class="hero-container">
        <nav class="navbar navbar-expand-lg border-bottom border-white border-opacity-10 py-3 fixed-navbar">
            <div class="container-fluid px-lg-5">
                <div class="d-none d-lg-flex gap-4">
                    <a href="#" class="nav-link-custom">Home</a>
                    <a href="#" class="nav-link-custom">About Us</a>
                    <a href="#" class="nav-link-custom">Accommodation</a>
                </div>

                <a class="navbar-brand mx-auto" href="#">
                    <img src="Assets/logo-aathi.png" alt="Logo" height="100">
                </a>

                <div class="d-flex align-items-center gap-4">
                    <div class="menu-wrapper" id="menuToggle">
                        <div class="hamburger">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <span class="menu-text">MENU</span>
                    </div>
                    
                    <button class="btn-check-availability d-none d-md-block" data-bs-toggle="modal" data-bs-target="#bookingModal">
                        CHECK AVAILABILITY
                    </button>
                </div>
            </div>
        </nav>

        <div class="hero-text-area text-center" data-aos="fade-up" data-aos-duration="1500">
            <h1 class="main-title">THE CITY <span class="dot">•</span> THE COAST <span class="dot">•</span> THE CONNECTION</h1>
            <p class="sub-title">A bold city escape to Colombo's spirited heart - where every detail connects you to the city's rhythm.</p>
            <div class="scroll-indicator">
                <div class="mouse-icon">
                    <div class="mouse-wheel"></div>
                </div>
            </div>
        </div>
    </div>

    
<?php echo $__env->yieldContent('content'); ?>

    <!-- Footer -->
    <footer class="footer-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6 mb-4">
                    <h5>Granbell Hotel</h5>
                    <p>282/5, Kollupitiya Road,<br>Marine Drive, Colombo 3, Sri Lanka.</p>
                    <p><strong>Hotline:</strong> +94 112 397 397</p>
                    <p><strong>Email:</strong> reservations@granbellhotel.lk</p>
                </div>
                <div class="col-lg-4 col-md-6 mb-4">
                    <h5>Quick Links</h5>
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Accommodation</a></li>
                        <li><a href="#">Dining</a></li>
                        <li><a href="#">Facilities</a></li>
                        <li><a href="#">Offers</a></li>
                        <li><a href="#">Contact Us</a></li>
                    </ul>
                </div>
                <div class="col-lg-4 col-md-12 mb-4">
                    <h5>Follow Us</h5>
                    <div class="footer-social">
                        <a href="#" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                        <a href="#" aria-label="Twitter"><i class="fab fa-twitter"></i></a>
                        <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
            </div>
            <div class="footer-copyright">
                <p>&copy; 2026 Granbell Hotel. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Review Popup -->
    <div class="review-popup" id="reviewPopup">
        <div class="review-content text-center">
            <button class="review-close" id="reviewToggle"><i class="fas fa-chevron-up"></i></button>
            <h6>4.3/5</h6>
            <p>"Excellent"</p>
            <span>13194 reviews</span>
            <div class="review-details">
                <button class="btn btn-sm btn-outline-secondary mt-2" onclick="document.getElementById('reviewPopup').style.display='none';">Close</button>
                <p class="mt-3">"The location is perfect, right by the beach. Highly recommend!"</p>
                <span>- Jane Smith</span>
                <p>"Excellent breakfast and friendly staff. Will definitely come back."</p>
                <span>- Mike Johnson</span>
            </div>
        </div>
    </div>

    <div class="menu-overlay" id="fullMenu">
        <button class="close-overlay" id="closeMenu">&times;</button>
        
        <div class="container h-100 d-flex align-items-center">
            <div class="row w-100">
                <div class="col-lg-4 d-none d-lg-block border-end border-white border-opacity-25 py-5">
                    <div class="contact-block mb-5">
                        <h6>Granbell Hotel</h6>
                        <p>282/5, Kollupitiya Road,<br>Marine Drive, Colombo 3, Sri Lanka.</p>
                    </div>
                    <div class="contact-block mb-5">
                        <h6>Hotline</h6>
                        <p>+94 112 397 397</p>
                    </div>
                    <div class="contact-block">
                        <h6>Email</h6>
                        <p>reservations@granbellhotel.lk</p>
                    </div>
                </div>

                <div class="col-lg-8 text-center text-lg-start ps-lg-5">
                    <ul class="overlay-nav-links">
                        <li><a href="#">Home</a></li>
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Accommodation</a></li>
                        <li><a href="#">Dining</a></li>
                        <li><a href="#">Facilities</a></li>
                        <li><a href="#">Offers</a></li>
                        <li><a href="#">Contact Us</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <script>
        const menuToggle = document.getElementById('menuToggle');
const closeMenu = document.getElementById('closeMenu');
const fullMenu = document.getElementById('fullMenu');

// Open Menu
menuToggle.addEventListener('click', () => {
    fullMenu.classList.add('active');
});

// Close Menu
closeMenu.addEventListener('click', () => {
    fullMenu.classList.remove('active');
});

// Close on 'Esc' key
document.addEventListener('keydown', (e) => {
    if (e.key === "Escape") fullMenu.classList.remove('active');
});
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- AOS Animation JS -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    <script>
        // Initialize AOS
        AOS.init({
            once: true, // whether animation should happen only once - while scrolling down
            offset: 100, // offset (in px) from the original trigger point
        });

        // Initialize Swiper
        var swiper = new Swiper(".accommodationSwiper", {
            slidesPerView: 1,
            spaceBetween: 10,
            loop: true,
            autoplay: {
                delay: 5000, // 5s auto sliding
                disableOnInteraction: false,
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
            breakpoints: {
                // when window width is >= 768px
                768: {
                    slidesPerView: 2,
                    spaceBetween: 20
                },
                // when window width is >= 1024px
                1024: {
                    slidesPerView: 3,
                    spaceBetween: 30
                }
            }
        });

        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.fixed-navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
                navbar.classList.remove('border-opacity-10');
            } else {
                navbar.classList.remove('scrolled');
                navbar.classList.add('border-opacity-10');
            }
        });

        // 5th Section Interactive slider logic
        const facilitiesData = [
            { title: "BANQUET HALL", subtitle: "Weddings, Conferences and More", img: "https://images.unsplash.com/photo-1519167758481-83f550bb49b3?q=80&w=1200&auto=format&fit=crop" },
            { title: "MEETING ROOM", subtitle: "Corporate Gatherings in Style", img: "https://images.unsplash.com/photo-1497366216548-37526070297c?q=80&w=1200&auto=format&fit=crop" },
            { title: "INFINITY POOL & JACUZZI", subtitle: "Endless Ocean Views", img: "https://images.unsplash.com/photo-1576013551627-0cc20b96c2a7?q=80&w=1200&auto=format&fit=crop" },
            { title: "SAUNA AND JACUZZI", subtitle: "Relaxation and Therapy", img: "https://images.unsplash.com/photo-1515362778563-6a8d0e44bc0b?q=80&w=1200&auto=format&fit=crop" },
            { title: "FITNESS CENTER", subtitle: "Stay Active During Your Stay", img: "https://images.unsplash.com/photo-1534438327276-14e5300c3a48?q=80&w=1200&auto=format&fit=crop" },
            { title: "LOTUS LOUNGE & SPA", subtitle: "Rejuvenate Your Senses", img: "https://granbellhotel.lk/wp-content/uploads/2025/04/Spa-1200x630-1.jpg" }
        ];

        const swiperWrapper = document.getElementById('facilitySwiperWrapper');
        const facilityMenuItems = document.querySelectorAll('.facility-item');

        // Populate Swiper perfectly to act as sliding cards
        facilitiesData.forEach(fac => {
            const slide = document.createElement('div');
            slide.className = 'swiper-slide w-100 h-100 position-relative';
            slide.innerHTML = `
                <img src="${fac.img}" class="facility-main-img w-100 h-100 object-fit-cover" alt="${fac.title}">
                <div class="facility-img-overlay">
                    <h4 class="text-uppercase letter-spacing-1 fw-light fs-4 mb-2">${fac.title}</h4>
                    <div class="wavy-line-white mb-2 d-flex justify-content-center">
                        <svg width="24" height="12" viewBox="0 0 24 12" fill="none" stroke="#fff" stroke-width="1.5" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 6 Q 3 2, 6 6 T 12 6 T 18 6 T 24 6" />
                        </svg>
                    </div>
                    <p class="small fw-light mb-3">${fac.subtitle}</p>
                    <button class="btn-explore">EXPLORE</button>
                </div>
            `;
            swiperWrapper.appendChild(slide);
        });

        // Initialize Swiper (creates genuine auto-sliding cards functionality!)
        const facilitiesSwiper = new Swiper('.facilitiesSwiper', {
            loop: true,
            effect: 'slide',
            speed: 600,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            on: {
                slideChange: function () {
                    // This runs every time the swiper auto slides (every 5s)
                    let index = this.realIndex;
                    facilityMenuItems.forEach(item => item.classList.remove('active'));
                    const activeItem = document.querySelector(`.facility-item[data-index="${index}"]`);
                    if (activeItem) activeItem.classList.add('active');
                }
            }
        });

        // Add robust click events to menu items
        facilityMenuItems.forEach(item => {
            item.addEventListener('click', (e) => {
                const index = parseInt(e.target.getAttribute('data-index'));
                
                // Instruct Swiper to slide directly to that card smoothly
                facilitiesSwiper.slideToLoop(index);
                
                // Mobile responsive scroll to image when tapped
                if (window.innerWidth < 992) {
                    const imgContainer = document.querySelector('.facility-img-container');
                    const offsetPosition = imgContainer.getBoundingClientRect().top + window.scrollY - 70; // 70px offset for the fixed navbar
                    window.scrollTo({
                         top: offsetPosition,
                         behavior: "smooth"
                    });
                }
            });
        });
    </script>

    <!-- Offers Swiper -->
    <script>
        const offersSwiper = new Swiper('.offersSwiper', {
            slidesPerView: 1,
            spaceBetween: 30,
            loop: true,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3,
                }
            }
        });
    </script>

    <!-- Footer Swiper -->
    <script>
        const footerSwiper = new Swiper('.footerSwiper', {
            slidesPerView: 1,
            loop: true,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            effect: 'fade',
            fadeEffect: {
                crossFade: true
            }
        });
    </script>

    <!-- Gallery Swiper -->
    <script>
        const gallerySwiper = new Swiper('.gallerySwiper', {
            slidesPerView: 1,
            spaceBetween: 10,
            loop: true,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            breakpoints: {
                768: {
                    slidesPerView: 3,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: 5,
                    spaceBetween: 20,
                }
            }
        });
    </script>

    <!-- Gallery Modal and Review Popup Scripts -->
    <script>
        function openGalleryModal(imageSrc) {
            document.getElementById('modalImage').src = imageSrc;
            const modal = new bootstrap.Modal(document.getElementById('galleryModal'));
            modal.show();
        }

        // Show review popup after 5 seconds
        setTimeout(() => {
            document.getElementById('reviewPopup').style.display = 'block';
        }, 5000);

        // Toggle review popup expand/collapse
        document.getElementById('reviewToggle').addEventListener('click', () => {
            const popup = document.getElementById('reviewPopup');
            const icon = document.querySelector('#reviewToggle i');
            if (popup.classList.contains('expanded')) {
                popup.classList.remove('expanded');
                icon.className = 'fas fa-chevron-up';
            } else {
                popup.classList.add('expanded');
                icon.className = 'fas fa-chevron-down';
            }
        });
    </script>

    <!-- Booking Modal -->
    <div class="modal fade" id="bookingModal" tabindex="-1" aria-labelledby="bookingModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content dark-theme">
                <div class="modal-header">
                    <h5 class="modal-title fw-light letter-spacing-1" id="bookingModalLabel">Book Your Stay</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="checkIn" class="form-label small text-uppercase letter-spacing-1">Check In</label>
                                <input type="date" class="form-control" id="checkIn">
                            </div>
                            <div class="col-md-6">
                                <label for="checkOut" class="form-label small text-uppercase letter-spacing-1">Check Out</label>
                                <input type="date" class="form-control" id="checkOut">
                            </div>
                            <div class="col-md-4">
                                <label for="adults" class="form-label small text-uppercase letter-spacing-1">Adults</label>
                                <select class="form-select" id="adults">
                                    <option value="1">1</option>
                                    <option value="2" selected>2</option>
                                    <option value="3">3</option>
                                    <option value="4">4+</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="children" class="form-label small text-uppercase letter-spacing-1">Children</label>
                                <select class="form-select" id="children">
                                    <option value="0" selected>0</option>
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3+</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="nationality" class="form-label small text-uppercase letter-spacing-1">Nationality</label>
                                <select class="form-select" id="nationality">
                                    <option value="local">Local</option>
                                    <option value="foreign">Foreign</option>
                                </select>
                            </div>
                            <div class="col-12 mt-4">
                                <label for="couponCode" class="form-label small text-uppercase letter-spacing-1">Have a Coupon code?</label>
                                <input type="text" class="form-control" id="couponCode" placeholder="Enter code here">
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary text-uppercase small letter-spacing-1" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary-teal text-uppercase small letter-spacing-1 px-4">Book Now</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Gallery Modal -->
    <div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="galleryModalLabel">Gallery Image</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <img id="modalImage" src="" alt="Gallery Image" class="img-fluid">
                </div>
            </div>
        </div>
    </div>
</body>
</html><?php /**PATH E:\laravel\aathi_Hotel\resources\views/Master.blade.php ENDPATH**/ ?>